unit WinForm;

////////////////////////////////////////////////////////////////////////////////
//  BDE .NET Demo
//  Written by Giuseppe Madaffari, giuseppe@giumad.com
//
//  ADVICE: this is just an example of BDE .NET. Note that BDE is now an old
//          technology and should not be used with new projects
//
//  IF YOU EXPERIENCE AN "ERROR LOADING IDAPI32.DLL" EXCEPTION, ADD THE BDE
//  DIRECTORY TO THE PATH ENVIRONMENT VARIABLE OF YOUR SYSTEM
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    TreeView1: System.Windows.Forms.TreeView;
    ListView1: System.Windows.Forms.ListView;
    Splitter1: System.Windows.Forms.Splitter;
    ColumnHeader1: System.Windows.Forms.ColumnHeader;
    ColumnHeader2: System.Windows.Forms.ColumnHeader;
    Panel1: System.Windows.Forms.Panel;
    Panel2: System.Windows.Forms.Panel;
    LinkLabel1: System.Windows.Forms.LinkLabel;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    Label3: System.Windows.Forms.Label;
    LinkLabel2: System.Windows.Forms.LinkLabel;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TreeView1_AfterSelect(sender: System.Object; e: System.Windows.Forms.TreeViewEventArgs);
    procedure ListView1_Resize(sender: System.Object; e: System.EventArgs);
    procedure LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure LinkLabel2_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    procedure ConnectBDE;
    constructor Create;
  end;

implementation

uses Borland.Vcl.DBTables, Borland.Vcl.Classes, DBViewer;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
type
  TSystem_Windows_Forms_TreeNodeArray = array of System.Windows.Forms.TreeNode;
  TSystem_Windows_Forms_ColumnHeaderArray = array of System.Windows.Forms.ColumnHeader;
begin
  Self.TreeView1 := System.Windows.Forms.TreeView.Create;
  Self.ListView1 := System.Windows.Forms.ListView.Create;
  Self.ColumnHeader1 := System.Windows.Forms.ColumnHeader.Create;
  Self.ColumnHeader2 := System.Windows.Forms.ColumnHeader.Create;
  Self.Splitter1 := System.Windows.Forms.Splitter.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.LinkLabel2 := System.Windows.Forms.LinkLabel.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Panel2 := System.Windows.Forms.Panel.Create;
  Self.LinkLabel1 := System.Windows.Forms.LinkLabel.Create;
  Self.Panel1.SuspendLayout;
  Self.Panel2.SuspendLayout;
  Self.SuspendLayout;
  // 
  // TreeView1
  // 
  Self.TreeView1.Dock := System.Windows.Forms.DockStyle.Left;
  Self.TreeView1.Enabled := False;
  Self.TreeView1.ImageIndex := -1;
  Self.TreeView1.Location := System.Drawing.Point.Create(0, 0);
  Self.TreeView1.Name := 'TreeView1';
  Self.TreeView1.Nodes.AddRange(TSystem_Windows_Forms_TreeNodeArray.Create(System.Windows.Forms.TreeNode.Create('Databases'), System.Windows.Forms.TreeNode.Create('Configuration', TSystem_Windows_Forms_TreeNodeArray.Create(System.Windows.Forms.TreeNode.Create('Drivers'), System.Windows.Forms.TreeNode.Create('System', TSystem_Windows_Forms_TreeNodeArray.Create(System.Windows.Forms.TreeNode.Create('Init'), System.Windows.Forms.TreeNode.Create('Formats', TSystem_Windows_Forms_TreeNodeArray.Create(System.Windows.Forms.TreeNode.Create('Date'), System.Windows.Forms.TreeNode.Create('Time'), System.Windows.Forms.TreeNode.Create('Number')))))))));
  Self.TreeView1.SelectedImageIndex := -1;
  Self.TreeView1.Size := System.Drawing.Size.Create(160, 413);
  Self.TreeView1.TabIndex := 1;
  Include(Self.TreeView1.AfterSelect, Self.TreeView1_AfterSelect);
  // 
  // ListView1
  // 
  Self.ListView1.BorderStyle := System.Windows.Forms.BorderStyle.None;
  Self.ListView1.Columns.AddRange(TSystem_Windows_Forms_ColumnHeaderArray.Create(Self.ColumnHeader1, Self.ColumnHeader2));
  Self.ListView1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.ListView1.Enabled := False;
  Self.ListView1.GridLines := True;
  Self.ListView1.HeaderStyle := System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
  Self.ListView1.LabelEdit := True;
  Self.ListView1.LabelWrap := False;
  Self.ListView1.Location := System.Drawing.Point.Create(0, 0);
  Self.ListView1.MultiSelect := False;
  Self.ListView1.Name := 'ListView1';
  Self.ListView1.Size := System.Drawing.Size.Create(337, 409);
  Self.ListView1.Sorting := System.Windows.Forms.SortOrder.Ascending;
  Self.ListView1.TabIndex := 2;
  Self.ListView1.View := System.Windows.Forms.View.Details;
  Include(Self.ListView1.Resize, Self.ListView1_Resize);
  // 
  // ColumnHeader1
  // 
  Self.ColumnHeader1.Text := 'Param';
  Self.ColumnHeader1.Width := 137;
  // 
  // ColumnHeader2
  // 
  Self.ColumnHeader2.Text := 'Value';
  Self.ColumnHeader2.Width := 200;
  // 
  // Splitter1
  // 
  Self.Splitter1.Location := System.Drawing.Point.Create(160, 0);
  Self.Splitter1.MinSize := 150;
  Self.Splitter1.Name := 'Splitter1';
  Self.Splitter1.Size := System.Drawing.Size.Create(3, 413);
  Self.Splitter1.TabIndex := 3;
  Self.Splitter1.TabStop := False;
  // 
  // Panel1
  // 
  Self.Panel1.BackColor := System.Drawing.SystemColors.Window;
  Self.Panel1.BorderStyle := System.Windows.Forms.BorderStyle.Fixed3D;
  Self.Panel1.Controls.Add(Self.LinkLabel2);
  Self.Panel1.Controls.Add(Self.Label3);
  Self.Panel1.Controls.Add(Self.Label2);
  Self.Panel1.Controls.Add(Self.Label1);
  Self.Panel1.Controls.Add(Self.Panel2);
  Self.Panel1.Controls.Add(Self.ListView1);
  Self.Panel1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.Panel1.Location := System.Drawing.Point.Create(163, 0);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(341, 413);
  Self.Panel1.TabIndex := 4;
  // 
  // LinkLabel2
  // 
  Self.LinkLabel2.Anchor := (System.Windows.Forms.AnchorStyles((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.LinkLabel2.Location := System.Drawing.Point.Create(216, 0);
  Self.LinkLabel2.Name := 'LinkLabel2';
  Self.LinkLabel2.Size := System.Drawing.Size.Create(112, 24);
  Self.LinkLabel2.TabIndex := 7;
  Self.LinkLabel2.TabStop := True;
  Self.LinkLabel2.Text := 'About this program...';
  Self.LinkLabel2.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  Include(Self.LinkLabel2.LinkClicked, Self.LinkLabel2_LinkClicked);
  // 
  // Label3
  // 
  Self.Label3.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label3.Location := System.Drawing.Point.Create(0, 32);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(336, 64);
  Self.Label3.TabIndex := 6;
  Self.Label3.Text := 'This sample program connects to BDE and shows the current defined aliases and c'+ 
  'onfiguration parameters. It also converts data from BDE table to ADO.NET datas'+ 
  'et and let you display it within a DataGrid or save it to XML files.';
  // 
  // Label2
  // 
  Self.Label2.Font := System.Drawing.Font.Create('Microsoft Sans Serif', 8.25, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (Byte(0)));
  Self.Label2.Location := System.Drawing.Point.Create(0, 0);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(104, 24);
  Self.Label2.TabIndex := 5;
  Self.Label2.Text := 'BDE .NET DEMO';
  Self.Label2.TextAlign := System.Drawing.ContentAlignment.MiddleLeft;
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
      or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label1.Location := System.Drawing.Point.Create(0, 96);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(336, 24);
  Self.Label1.TabIndex := 4;
  Self.Label1.Text := 'Select any leaf node from the treeview...';
  Self.Label1.TextAlign := System.Drawing.ContentAlignment.MiddleLeft;
  // 
  // Panel2
  // 
  Self.Panel2.Controls.Add(Self.LinkLabel1);
  Self.Panel2.Dock := System.Windows.Forms.DockStyle.Bottom;
  Self.Panel2.Location := System.Drawing.Point.Create(0, 385);
  Self.Panel2.Name := 'Panel2';
  Self.Panel2.Size := System.Drawing.Size.Create(337, 24);
  Self.Panel2.TabIndex := 3;
  Self.Panel2.Visible := False;
  // 
  // LinkLabel1
  // 
  Self.LinkLabel1.Dock := System.Windows.Forms.DockStyle.Fill;
  Self.LinkLabel1.Location := System.Drawing.Point.Create(0, 0);
  Self.LinkLabel1.Name := 'LinkLabel1';
  Self.LinkLabel1.Size := System.Drawing.Size.Create(337, 24);
  Self.LinkLabel1.TabIndex := 0;
  Self.LinkLabel1.TabStop := True;
  Self.LinkLabel1.Text := 'Launch BDE .NET Database Explorer...';
  Self.LinkLabel1.TextAlign := System.Drawing.ContentAlignment.MiddleRight;
  Include(Self.LinkLabel1.LinkClicked, Self.LinkLabel1_LinkClicked);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(504, 413);
  Self.Controls.Add(Self.Panel1);
  Self.Controls.Add(Self.Splitter1);
  Self.Controls.Add(Self.TreeView1);
  Self.MinimumSize := System.Drawing.Size.Create(300, 300);
  Self.Name := 'TWinForm';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'BDE .NET Demo';
  Include(Self.Load, Self.TWinForm_Load);
  Self.Panel1.ResumeLayout(False);
  Self.Panel2.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //

end;

procedure TWinForm.LinkLabel2_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  MessageBox.Show('"Borland Delphi 8.0 for Microsoft .NET Framework" Sample Application'#13#10#13#10+
    'Written by Giuseppe Madaffari'#13#10+
    'email: giuseppe@giumad.com',
    'FileSystemWatcher');
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
  ConnectBDE;
  ListView1.BringToFront;
end;

procedure TWinForm.LinkLabel1_LinkClicked(sender: System.Object; e: System.Windows.Forms.LinkLabelLinkClickedEventArgs);
begin
  DBViewer.TWinForm1.ShowForm(TreeView1.SelectedNode.Text);
end;

procedure TWinForm.ListView1_Resize(sender: System.Object; e: System.EventArgs);
begin
  ListView1.Columns[1].Width := ListView1.Width - ListView1.Columns[0].Width - 5;
end;

procedure TWinForm.TreeView1_AfterSelect(sender: System.Object; e: System.Windows.Forms.TreeViewEventArgs);
var
  I: Integer;
  Sess: TSession;
  List: TStringList;
  Item: TreeNode;
  S: String;
begin
  Item := e.Node;
  Panel2.Visible := False;
  if Assigned(Item) and Assigned(Item.Parent) then
  begin
    Sess := TSession.Create(nil);
    Sess.AutoSessionName := True;
    Sess.Open;
    ListView1.Items.Clear;
    List := TStringList.Create;

    if Item.Parent.Text.Equals('Databases') then  // alias
    begin
      Sess.GetAliasParams(Item.Text, List);
      List.Add('.Driver=' + Sess.GetAliasDriverName(Item.Text));
      Panel2.Visible := True;
    end
    else if Item.Nodes.Count = 0 then begin
      if Item.Parent.Text.Equals('Drivers') then  // drivers
      begin
        Sess.GetDriverParams(Item.Text, List);
      end
      else begin  // config parameters
        S := Item.FullPath.ToUpper;
        S := S.Remove(0, S.IndexOf('\'));
        Sess.GetConfigParams(S, '', List);
      end;
    end;

    for I := 0 to List.Count - 1 do
      ListView1.Items.Add(List.Names[I]).SubItems.Add(List.Values[List.Names[I]]);

    Sess.Close;
  end
  else
    ListView1.Items.Clear;

  ListView1.Visible := ListView1.Items.Count > 0;
end;

procedure TWinForm.ConnectBDE;
var
  I: Integer;
  Sess: TSession;
  List: TStringList;
  Node: TreeNode;
  S: String;
begin
  Sess := TSession.Create(nil);
  Sess.AutoSessionName := True;
  Sess.Open;
  List := TStringList.Create;
  Sess.GetAliasNames(List);
  Node := TreeView1.TopNode.NextNode.FirstNode;  //Drivers node

  for I := 0 to List.Count - 1 do
  begin
    TreeView1.TopNode.Nodes.Add(List[I]);
  end;

  // load list of installed BDE drivers
  List.Clear;
  Sess.GetDriverNames(List);
  for I := 0 to List.Count - 1 do
  begin
    S := List[I];
    Node.Nodes.Add(S.Replace('=', ''));
  end;

  TreeView1.CollapseAll;

  Sess.Close;

  TreeView1.Enabled := True;
  ListView1.Enabled := True;
end;

end.
